<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class VerifyPassword
{
    public function handle(Request $request, Closure $next)
    {
        if (!Auth::guard()->validate([
            'email' => Auth::user()->email,
            'password' => $request->password,
        ])) {
            return redirect()->back()->withErrors(['password' => 'Incorrect password']);
        }

        return $next($request);
    }
}