@php
    $primaryColor = getArrayValue($setting?->theme_setting, 'primary_color') ?? '#1b5e20'; // Dark Green
    $primaryLightFirstColor = hex2rgba($primaryColor, 0.15); // Light Green accent
    $primaryLightSecondColor = hex2rgba($primaryColor, 0.08); // Slightly lighter Green
    $secondaryColor = getArrayValue($setting?->theme_setting, 'secondary_color') ?? '#a5d6a7'; // Light Green
    $primaryTextColor = getArrayValue($setting?->theme_setting, 'primary_text_color') ?? '#ffffff'; // White
    $secondaryTextColor = getArrayValue($setting?->theme_setting, 'secondary_text_color') ?? '#b9f6ca'; // Light complementary color
@endphp
<style>
    :root {
        color-scheme: dark;
        --font-primary: "Poppins", sans-serif;
        --font-secondary: "Poppins", sans-serif;
        --color-primary: @php echo $primaryColor @endphp;
        --color-primary-light: @php echo $primaryLightFirstColor @endphp;
        --color-primary-light-2: @php echo $primaryLightSecondColor @endphp;
        --color-primary-text: #ffffff;
        --text-primary: @php echo $primaryTextColor @endphp;
        --text-secondary: @php echo $secondaryTextColor @endphp;
        --color-complementary: #ffcc00;
        --text-complementary: #ffecb3;
        --color-accent: #ff5722;
        --text-accent: #ffccbc;
        --text-light: #e0f2f1;
        --color-border: #2e7d32;
        --border-primary: rgba(0, 77, 64, 0.5);
        --border-light: rgba(255, 255, 255, .2);
        --color-dark: #004d40;
        --color-dark-2: #00332e;
        --bg-light: #2e7d32;
        --site-bg: #1b5e20;
        --card-bg: #2e7d32;
        --topbar-bg: #004d40;
        --sidebar-bg: #1b5e20;
        --color-success: #00c853;
        --color-success-light: rgba(0, 200, 83, 0.12);
        --success-border: rgba(0, 200, 83, 0.4);
        --color-danger: #d32f2f;
        --color-danger-light: rgba(211, 47, 47, 0.12);
        --danger-border: rgba(211, 47, 47, 0.4);
        --color-warning: #ffcc00;
        --color-warning-light: rgba(255, 204, 0, 0.15);
        --color-info: #0288d1;
        --color-info-light: rgba(2, 136, 209, 0.15);
        --color-green: #1b5e20;
        --color-green-light: rgba(27, 94, 32, 0.1);
        --color-purple: #8e24aa;
        --color-purple-light: rgba(142, 36, 170, 0.1);
        --color-blue: #0288d1;
        --color-blue-light: rgba(2, 136, 209, 0.1);
    }

</style>
