<?php $__env->startSection('panel'); ?>
    <section>
        <?php echo $__env->make('admin.partials.table', [
            'columns' => [
                'full_name' => __('admin.table.name'),
                'email' => __('admin.table.email'),
                'user_kyc_status' => __('KYC Status'),
                'user_identity_information' => __('identity Information'),
                'action' => __('admin.table.action'),
            ],
            'rows' => $users,
            'page_identifier' => \App\Enums\PageIdentifier::KYC_IDENTITY->value,
       ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </section>

    <div class="modal fade" id="kycIdentityModal" tabindex="-1" aria-labelledby="credit-add-return" aria-hidden="true">
        <div class="modal-dialog modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><?php echo e(__('Identity Verification Update')); ?></h5>
                </div>
                <form action="<?php echo e(route('admin.user.identity.update')); ?>" method="POST">
                    <?php echo method_field('PUT'); ?>
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="id" value="">
                    <div class="modal-body">
                        <div class="mb-3">
                            <label for="kyc_status" class="form-label"> <?php echo e(__('KYC Status')); ?> <sup class="text--danger">*</sup></label>
                            <select class="form-select" name="kyc_status" id="kyc_status" required>
                                <?php $__currentLoopData = \App\Enums\User\KycStatus::cases(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if (! (in_array($status->value, [\App\Enums\User\KycStatus::REQUESTED->value]))): ?>
                                        <option value="<?php echo e($status->value); ?>"><?php echo e(\App\Enums\User\KycStatus::getName($status->value)); ?></option>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    </div>

                    <div class="modal-footer">
                        <div class="d-flex align-items-center gap-3">
                            <button type="button" class="btn btn--outline btn--sm" data-bs-dismiss="modal"> <?php echo e(__('admin.button.cancel')); ?></button>
                            <button type="submit" class="btn btn--primary btn--sm"> <?php echo e(__('admin.button.save')); ?></button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div class="modal fade" id="identity-information" tabindex="-1" aria-labelledby="list-wallet" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><?php echo e(__('KYC Identity Information')); ?></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <ul class="modal-identity-list modal-pay-list"></ul>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn--danger btn--sm" data-bs-dismiss="modal"><?php echo e(__('admin.button.closed')); ?></button>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script-push'); ?>
    <script>
        "use strict";
        $(document).ready(function () {
            $('.kyc_identity').on('click', function () {
                const modal = $('#kycIdentityModal');
                const id = $(this).data('id');
                modal.find('input[name=id]').val(id);
                modal.modal('show');
            });

            $('.identity-info').on('click', function () {
                $('.modal-identity-list').empty();
                const modal = $('#identity-information');
                const meta = $(this).data('meta');

                if (typeof meta === 'object' && Object.keys(meta).length !== 0) {
                    Object.keys(meta).forEach(key => {
                        const propertyName = key.replace(/_/g, ' ').replace(/\b\w/g, l => l.toUpperCase());
                        let propertyValue = meta[key];
                
                        const imageExtensions = ['jpg', 'jpeg', 'png', 'gif', 'bmp', 'webp'];
                        const fileExtension = propertyValue.split('.').pop().toLowerCase();
                
                        if (imageExtensions.includes(fileExtension)) {
                            propertyValue = `<div class="kyc-image"><img src="https://alfxtrade.com/assets/files/${propertyValue}" alt="${propertyName}" /></div>`;
                        }
                
                        const listItem = `<li>
                                <span>${propertyName}</span>
                                <span>${propertyValue}</span>
                              </li>`;
                
                        modal.find('.modal-identity-list').append(listItem);
                    });
                }

                modal.modal('show');
            });


        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/alfxtrad/public_html/src/resources/views/admin/user/identity.blade.php ENDPATH**/ ?>