<?php $__env->startSection('content'); ?>
    <div class="main-content" data-simplebar>
        <div class="row">
            <div class="col-lg-12">
                <div class="row g-4">
                    <div class="col-lg-5">
                        <div class="i-card-sm mb-4">
                            <h5 class="title"><?php echo e(__($setTitle)); ?></h5>
                            <div class="d-flex align-items-center gap-3 mb-4">
                                <?php $__currentLoopData = ['Trade Balance', 'Practice Balance']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $balanceType): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="i-card-sm bg--dark shadow-none flex-grow-1 py-3 px-4 rounded-3">
                                        <span class="inline-block lh-1 text--light"><?php echo e(__($balanceType)); ?></span>
                                        <h5 class="mt-2"><?php echo e(getCurrencySymbol()); ?><?php echo e(shortAmount(Auth::user()->wallet->{$balanceType === 'Trade Balance' ? 'trade_balance' : 'practice_balance'})); ?></h5>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>

                            <ul class="d-flex flex-column gap-2">
                                <?php $__currentLoopData = ['total', 'today', 'wining', 'loss', 'draw', 'high', 'low']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li class="p-3 d-flex bg--dark">
                                        <div class="flex-grow-1 d-flex align-items-center gap-3">
                                            <h5 class="text--light fs-14"><?php echo e(__("admin.report.statistics.trade.one.{$key}")); ?></h5>
                                        </div>
                                        <div class="flex-shrink-0 text-end">
                                            <h5 class="text-white fw-bold fs-14"><?php echo e(getCurrencySymbol()); ?><?php echo e(shortAmount($trade->$key)); ?></h5>
                                        </div>
                                    </li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                    </div>
                    <div class="col-lg-7">
                        <div class="i-card-sm">
                            <div id="totalTrade"></div>
                        </div>
                    </div>
                </div>

                <div class="i-card-sm mb-4">
                    <div class="card-header">
                        <h4 class="title"><?php echo e(__($setTitle)); ?></h4>
                    </div>
                    <div class="filter-area">
                        <form action="<?php echo e(route('user.trade.tradelog')); ?>">
                            <div class="row row-cols-lg-4 row-cols-md-4 row-cols-sm-2 row-cols-1 g-3">
                                <div class="col">
                                    <select class="select2-js" name="outcome">
                                        <?php $__currentLoopData = App\Enums\Trade\TradeOutcome::cases(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($status->value); ?>" <?php if($status->value == request()->outcome): ?> selected <?php endif; ?>><?php echo e($status->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                                <div class="col">
                                    <select class="select2-js" name="volume">
                                        <?php $__currentLoopData = App\Enums\Trade\TradeVolume::cases(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($status->value); ?>" <?php if($status->value == request()->volume): ?> selected <?php endif; ?>><?php echo e($status->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                                <div class="col">
                                    <input type="text" id="date" class="form-control datepicker-here" name="date"
                                       value="<?php echo e(request()->get('date')); ?>" data-range="true" data-multiple-dates-separator=" - "
                                       data-language="en" data-position="bottom right" autocomplete="off"
                                       placeholder="<?php echo e(__('Date')); ?>">
                                </div>
                                <div class="col">
                                    <button type="submit" class="i-btn btn--lg btn--primary w-100"><i class="bi bi-search me-3"></i><?php echo e(__('Search')); ?></button>
                                </div>
                            </div>
                        </form>
                    </div>

                    <div class="table-container">
                        <?php echo $__env->make('user.partials.trade.trade-history', ['tradeLogs' => $tradeLogs], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                    <div class="mt-4"><?php echo e($tradeLogs->links()); ?></div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script-push'); ?>
    <script>
        "use strict";

        $(document).ready(function () {
            const amount = <?php echo json_encode($amount, 15, 512) ?>;
            const days = <?php echo json_encode($days, 15, 512) ?>;
            const currency = "<?php echo e(getCurrencySymbol()); ?>";
            const content = "<?php echo e(__('admin.report.statistics.trade.five')); ?>";
            const tradeContent = "<?php echo e(__('Trade Amount')); ?>";

            const options = {
                series: [{
                    name: tradeContent,
                    data: amount
                }],
                chart: {
                    type: 'bar',
                    height: 535,
                    toolbar: false,
                    foreColor: '#ffffff'
                },
                plotOptions: {
                    bar: {
                        horizontal: false,
                        columnWidth: '50%',
                        endingShape: 'rounded'
                    },
                },
                dataLabels: {
                    enabled: false
                },
                stroke: {
                    show: true,
                    width: 2,
                    colors: ['transparent']
                },
                xaxis: {
                    categories: days,
                    labels: {
                        style: {
                            colors: '#ffffff' 
                        }
                    }
                },
                yaxis: {
                    title: {
                        text: content,
                        style: {
                            color: '#ffffff' 
                        }
                    },
                    labels: {
                        style: {
                            colors: '#ffffff'
                        }
                    }
                },
                fill: {
                    opacity: 1
                },
                tooltip: {
                    y: {
                        formatter: function (val) {
                            return currency + val;
                        },
                        style: {
                            color: '#ffffff'
                        }
                    }
                }
            };
            const chart = new ApexCharts(document.querySelector("#totalTrade"), options);
            chart.render();
        });

    </script>
<?php $__env->stopPush(); ?>


<?php echo $__env->make('layouts.user', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/alfxtrad/public_html/src/resources/views/user/trade/trade_log.blade.php ENDPATH**/ ?>