<?php $__env->startSection('panel'); ?>
    <section>
        <div class="row">
            <div class="col-xl-8 mx-auto">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title"><?php echo e($setTitle); ?></h4>
                    </div>
                    <div class="card-body">
                        <ul class="list-group mb-4 detail-list">
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                <?php echo e(__('Initiated At')); ?>

                                <span class="fw-bold"><?php echo e(showDateTime($deposit->created_at)); ?></span>
                            </li>
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                <?php echo e(__('Gateway')); ?>

                                <span class="fw-bold"> <?php echo e($deposit->gateway->name ?? 'N/A'); ?></span>
                            </li>
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                <?php echo e(__('Rate')); ?>

                                <span class="fw-bold"><?php echo e(getCurrencySymbol()); ?>1 =  <?php echo e(shortAmount($deposit->rate)); ?> <?php echo e($deposit->gateway->currency ??  getCurrencyName()); ?></span>
                            </li>
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                <?php echo e(__('Trx')); ?>

                                <span class="fw-bold"><?php echo e($deposit->trx); ?></span>
                            </li>
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                <?php echo e(__('Deposit Amount')); ?>

                                <span class="fw-bold"><?php echo e(getCurrencySymbol()); ?><?php echo e(shortAmount($deposit->amount)); ?></span>
                            </li>
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                <?php echo e(__('Charge')); ?>

                                <span class="fw-bold"><?php echo e(getCurrencySymbol()); ?><?php echo e(shortAmount($deposit->charge)); ?></span>
                            </li>
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                <?php echo e(__('Final Amount')); ?>

                                <span class="fw-bold"><?php echo e(getCurrencySymbol()); ?><?php echo e(shortAmount($deposit->final_amount)); ?></span>
                            </li>
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                <?php echo e(__('Status')); ?>

                                <span class="badge <?php echo e(\App\Enums\Payment\Deposit\Status::getColor($deposit->status)); ?>"><?php echo e(\App\Enums\Payment\Deposit\Status::getName($deposit->status)); ?></span>
                            </li>
                        </ul>

                        <div class="row gy-4 mt-3">
                            <?php if($deposit->gateway->parameter && $deposit->meta): ?>
                                <div class="col-12">
                                    <h6 class="fs-15 mb-2"><?php echo e(__('Payment Information')); ?></h6>
                                    <ul class="list-group">
                                        <?php $__currentLoopData = $deposit->gateway->parameter; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $parameter): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php if(\Illuminate\Support\Arr::get($parameter, 'field_type', 'text') == 'file'): ?>
                                                <li class="list-group-item d-flex justify-content-between align-items-center">
                                                    <?php echo e(\Illuminate\Support\Arr::get($parameter, 'field_label','')); ?>

                                                    <a href="<?php echo e(route('admin.deposit.download', base64_encode( \Illuminate\Support\Arr::get($deposit->meta, \Illuminate\Support\Arr::get($parameter, 'field_name','')) ?? 'N/A'))); ?>" class="btn btn-sm btn--primary" ><i class="las la-download"></i></a>
                                                </li>
                                            <?php else: ?>
                                                <li class="list-group-item d-flex justify-content-between align-items-center">
                                                    <?php echo e(\Illuminate\Support\Arr::get($parameter, 'field_label','')); ?>

                                                    <span><?php echo e(\Illuminate\Support\Arr::get($deposit->meta, \Illuminate\Support\Arr::get($parameter, 'field_name','')) ?? 'N/A'); ?></span>
                                                </li>
                                            <?php endif; ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                                </div>
                            <?php endif; ?>

                           <?php if($deposit->status == \App\Enums\Payment\Deposit\Status::PENDING->value): ?>
                               <div class="col-12 text-center">
                                   <h6 class="fs-15 mb-2"><?php echo e(__('Check the deposit details and update its status.')); ?></h6>
                                   <button type="button" class="btn btn-md btn--primary" data-bs-toggle="modal" data-bs-target="#exampleModal">Payment Actions</button>
                               </div>
                           <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <?php if($deposit->status == \App\Enums\Payment\Deposit\Status::PENDING->value): ?>
        <div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLabel">Update Deposit Status</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <form action="<?php echo e(route('admin.deposit.update', $deposit->id)); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('PUT'); ?>
                        <div class="modal-body">
                            <div class="mb-3">
                                <label for="status" class="form-label"><?php echo e(__('Status')); ?><sup class="text-danger">*</sup></label>
                                <select class="form-select" id="status" name="status" required>
                                    <option value="<?php echo e(\App\Enums\Payment\Deposit\Status::SUCCESS->value); ?>"><?php echo e(__('Approved')); ?></option>
                                    <option value="<?php echo e(\App\Enums\Payment\Deposit\Status::CANCEL->value); ?>"><?php echo e(__('Cancel')); ?></option>
                                </select>
                            </div>
                        </div>

                        <div class="modal-footer">
                            <button type="button" class="btn btn--outline btn--sm" data-bs-dismiss="modal"><?php echo e(__('Close')); ?></button>
                            <button type="submit" class="btn btn--primary btn--sm"><?php echo e(__('Submit')); ?></button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/alfxtrad/public_html/src/resources/views/admin/deposit/details.blade.php ENDPATH**/ ?>