<table id="myTable" class="table">
    <thead>
        <tr>
            <th scope="col"><?php echo e(__('Initiated At')); ?></th>
            <th scope="col"><?php echo e(__('Crypto')); ?></th>
            <th scope="col"><?php echo e(__('Price')); ?></th>
            <th scope="col"><?php echo e(__('Amount')); ?></th>
            <th scope="col"><?php echo e(__('Arrival Time')); ?></th>
            <th scope="col"><?php echo e(__('Volume')); ?></th>
            <th scope="col"><?php echo e(__('Outcome')); ?></th>
            <th scope="col"><?php echo e(__('Status')); ?></th>
        </tr>
    </thead>
    <tbody>
        <?php $__empty_1 = true; $__currentLoopData = $tradeLogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $tradeLog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <tr>
                <td data-label="<?php echo e(__('Initiated At')); ?>">
                    <?php echo e(showDateTime($tradeLog->created_at)); ?>

                </td>
                <td data-label="<?php echo e(__('Crypto')); ?>">
                    <?php echo e($tradeLog->cryptoCurrency->name); ?>

                </td>
                <td data-label="Price">
                    $<?php echo e(shortAmount($tradeLog->original_price)); ?>

                </td>
                <td data-label="<?php echo e(__('Amount')); ?>">
                    <?php if($tradeLog->outcome == \App\Enums\Trade\TradeOutcome::WIN->value): ?>
                        <?php echo e(getCurrencySymbol()); ?><?php echo e(shortAmount($tradeLog->amount)); ?>

                        +
                        <?php echo e(getCurrencySymbol()); ?><?php echo e(shortAmount($tradeLog->winning_amount)); ?>

                        =
                        <span class="text--success">
                            <?php echo e(getCurrencySymbol()); ?><?php echo e(shortAmount($tradeLog->amount + $tradeLog->winning_amount)); ?>

                        </span>
                    <?php elseif($tradeLog->outcome == \App\Enums\Trade\TradeOutcome::LOSE->value): ?>
                        <span class="text--danger"><?php echo e(getCurrencySymbol()); ?><?php echo e(shortAmount($tradeLog->amount)); ?></span>
                    <?php else: ?>
                        <span class="text--primary"><?php echo e(getCurrencySymbol()); ?><?php echo e(shortAmount($tradeLog->amount)); ?></span>
                    <?php endif; ?>
                </td>
                <td data-label="<?php echo e(__('Arrival Time')); ?>">
                    <?php echo e(showDateTime($tradeLog->arrival_time)); ?>

                </td>
                <td data-label="<?php echo e(__('Volume')); ?>">
                    <span class="i-badge <?php echo e(\App\Enums\Trade\TradeVolume::getColor($tradeLog->volume)); ?>">
                     <?php echo e(\App\Enums\Trade\TradeVolume::getName($tradeLog->volume)); ?>

                    </span>
                </td>
                <td data-label="<?php echo e(__('Outcome')); ?>">
                     <span class="i-badge <?php echo e(\App\Enums\Trade\TradeOutcome::getColor($tradeLog->outcome)); ?>">
                         <?php echo e(\App\Enums\Trade\TradeOutcome::getName($tradeLog->outcome)); ?>

                    </span>
                </td>
                <td data-label="<?php echo e(__('Status')); ?>">
                     <span class="i-badge <?php echo e(\App\Enums\Trade\TradeStatus::getColor($tradeLog->status)); ?>">
                         <?php echo e(\App\Enums\Trade\TradeStatus::getName($tradeLog->status)); ?>

                    </span>
                </td>
            </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <tr>
                <td class="text-white text-center" colspan="100%"><?php echo e(__('No Data Found')); ?></td>
            </tr>
        <?php endif; ?>
    </tbody>
</table>
<?php /**PATH /home/alfxtrad/public_html/src/resources/views/user/partials/trade/trade-history.blade.php ENDPATH**/ ?>